# 消息报文定义
```json
{
  "Message": {
    "type": "object",
    "title": "报文",
    "properties": {
      "MessageID": {
        "type": "string"
      },
      "Timestamp": {
        "type": "string",
        "title": "消息生成时间"
      },
      "Body": {
        "type": "string",
        "title": "报文体"
      },
      "Header": {
        "type": "array",
        "title": "报文参数",
        "items": {
          "type": "object",
          "properties": {
            "Key": {
              "type": "string",
              "title": "健"
            },
            "Value": {
              "type": "string",
              "title": "值"
            }
          },
          "required": [
            "Value",
            "Key"
          ],
          "maxProperties": 2,
          "minProperties": 2
        }
      },
      "Property": {
        "type": "array",
        "title": "编排附加属性",
        "items": {
          "type": "object",
          "properties": {
            "Key": {
              "type": "string",
              "title": "健"
            },
            "Value": {
              "type": "string",
              "title": "值"
            }
          },
          "required": [
            "Value",
            "Key"
          ],
          "maxProperties": 2,
          "minProperties": 2
        }
      }
    },
    "required": [
      "Timestamp",
      "Body",
      "Header",
      "Property",
      "MessageID"
    ]
  }
}
```

# 模板名字
- 分类
- 输出
- 处理逻辑
- camel组件
- 静态配置据结构
- 运行时数据结构

# 顺序执行
- 分类:流程控制
- 输出:最后一个child节点的输出结果
- 处理逻辑
  - 管道过滤器模型(pipe-filter)
  - 前节点的输出传入后节点的输入
- camel组件:
  - CamelComponents/EIP/Pipeline
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"pipeline",
  "children":[

  ]
}
```

# 并行执行
- 分类:流程控制
- 输出:最后一个节点的输出结果
- 处理逻辑  
  - 组播模型(broadcast)
  - 所有节点使用最初的消息作为输入
  - 可以控制并发数量,默认并发1
  - 最后一个节点的输出作为整个节点的输出
- camel组件:
  - CamelComponents/EIP/Multicast
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"multicast",
  "copy":false,
  "parallel_processing":1,
  "timeout":0,
  "stop_on_exception":false,
  "children":[

  ]
}
```

# 断路器
- 分类:流程控制
- 输出:normal或fallback的输出
- 处理逻辑
  - 断路器模型
  - 正常逻辑有异常或超时则执行降级逻辑
- camel组件:
  - CamelComponents/EIP/CircuitBreaker
  - CamelComponents/EIP/Resilience4jCircuitBreaker
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"circuit_breaker",
  "timeout":0,
  "children":[
    
  ],
  "on_fallback":[

  ]
}
```

# 条件分支
- 分类:流程控制
- 输出:理论上匹配的分支为输出结果。当无otherwise且无匹配的分支时无输出
- 处理逻辑
  - 消息体路由模型(content based router)
  - 前面的匹配到会阻止后面
  - 是if-elif-else语义.不是switch-case语义
  - 每个条件断言只运行一次
  - 只会有0-1个分支被路由到
- camel组件:
  - CamelComponents/EIP/ContentBasedRouter
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"choise",
  "children":[
    {
      "node":"when",
      "condition":"header.id==1",
      "children":[

      ]
    },
    {
      "node":"when",
      "condition":"header.id==2",
      "children":[
        
      ]
    },
    {
      "node":"otherwise",
      "children":[
        
      ]
    }
  ]
}
```

# 消息过滤
- 分类:流程控制
- 输出:匹配的表达式为输出结果。无匹配则无输出
- 处理逻辑
  - 消息过滤模型(filter)
  - if断言语义
  - 表达式成功消息会透传路由,否则被拦截
- camel组件:
  - CamelComponents/EIP/Filter
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"filter",
  "expression":"header.id==2",
  "children":[
    
  ]
}
```
# 定长循环
- 分类:流程控制
- 输出:child节点的输出结果
- 处理逻辑
  - copy:true时每次循环迭代会传入新实例,false时会传入上次实例
  - 表达式返回必须是一个整数,作为运行时计算的循环次数
  - 定长循环或迭代器语义
  - for
    - expresion:js:计算循环次数
    - copy:bool:深度克隆消息
    - children:stmts:循环体
  - exchangeProperty
    - CamelLoopSize:循环总次数
    - CamelLoopIndex:循环变量
- camel组件:
  - CamelComponents/EIP/Loop
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"loop",
  "expression":"{count}",
  "copy":false,
  "children":[
    
  ],
  "exchangeProperty":{
    "CamelLoopSize":2,
    "CamelLoopIndex":12
  }
}
```
# 动态循环
- 分类:流程控制
- 输出:匹配的表达式为输出结果。无匹配则无输出
- 处理逻辑
  - predicate必须返回bool.
  - 表达式会在每次执行循环体前计算一次
  - copy:true时每次循环迭代会传入新实例,false时会传入上次实例
  - while-loop语义
  - loop
    - predicate:js:计算循环是否继续
    - copy:bool:深度克隆消息
    - children:stmts:循环体
  - exchangeProperty
    - CamelLoopIndex:循环变量
- camel组件:
  - CamelComponents/EIP/Loop
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"loop",
  "predicate":"{header.id==2}",
  "copy":true,
  "children":[
    
  ],
  "exchangeProperty":{
    "CamelLoopIndex":2
  }
}
```
# 结束 
- 分类:流程控制
- 输出:无输出
- 处理逻辑
  - 结束编排,停止所有分支和后续请求
  - stop
    - 无参数
- camel组件:
  - CamelComponents/EIP/Stop
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"stop"
}
```
# 消息处理器
- 分类:消息处理
- 输出:child的最后一个输出
- 处理逻辑
  - 处理消息报文
  - 消息体过滤器模型(content filter)
  - 参数和返回都是消息体对象
  - 可以直接编辑并返回输入消息体对象
  - contentFilter
    - statusPropertyName:string:保存过滤器处理标记
    - script:js:处理消息报文的脚本
- camel组件:
  - CamelComponents/EIP/ContentFilter
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"contentfilter",
  "statusPropertyName":"keyword",
  "script":"ss://xxx.js",
  "children":[
    
  ]
}
```
# 添加参数
- 分类:消息处理
- 输出:child最后一个输出
- 处理逻辑
  - 在header/parameter中增加kv
  - 在原对象修改
  - addHeader
    - key_expr:js:健表达式
    - value_expr:js:值表达式
- camel组件:
  - CamelComponents/EIP/SetHeader
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"setHeader",
  "name":"headername",
  "expression":{
    "const":"test"
  },
  "children":[
    
  ]
}
```

# 添加编排附加属性
- 分类:消息处理
- 输出:child最后一个输出
- 处理逻辑
  - 在property中增加kv
  - 在原对象修改
  - addProperty
    - key_expr:js:健表达式
    - value_expr:js:值表达式
- camel组件:
  - CamelComponents/EIP/SetProperty
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"setProperty",
  "name":"myProperty",
  "expression":{
    "const":"test"
  },
  "children":[
    
  ]
}
```

# 设置报文体
- 分类:消息处理
- 输出:child最后一个输出
- 处理逻辑
  - 覆盖报文体
  - 在原对象修改
  - setBody
    - expresion:js:报文体表达式
- camel组件:
  - CamelComponents/EIP/SetBody
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"setBody",
  "expresion":{
    "const":"随便输入点啥"
  },
  "children":[
    
  ]
}
```

# 调用接口
- 分类:消息处理
- 输出:child最后一个输出
- 处理逻辑
  - 调用外部接口并接收返回
  - callAPI
    - type:string:api/endpoint 已发布API或三方http端点
    - target:string:目标ID
- camel组件:
  - CamelComponents/Components/ahc
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"to_http",
  "type":"api/endpoint",
  "target":"目标ID",
  "method":"POST",
  "url":"http://www.baidu.com/api"
}
```

# 发送事件消息
- 分类:消息处理
- 输出:child最后一个输出
- 处理逻辑
  - 发送消息至事件
  - 不修改消息内容
  - pushEvent
    - type:string:event/endpoint 已发布事件或三方mq端点
    - target:string:目标ID
- camel组件:
  - CamelComponents/Components/AMQP
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"toamqp",
  "pushEvent":{
    "type":"event",
    "target":"5t345646754"
  }
}
```

# 拆分
- 分类:消息处理
- 输出:串行为最后一个child输出，并行为多个child输出
- 处理逻辑
  - 把一个消息报文拆分成多个,并分发执行
  - 默认outputMethod返回in消息
  - 可以自定义outputMethod处理拆分节点的输出
  - outputMethod会迭代调用
  - split
    - scriptMethod:js:拆分脚本,返回可迭代对象[]
    - outputMethod:js:输出脚本
    - parallelProcessing:bool:并发执行每个子消息报文
    - timeout:int:全局超时毫秒
    - copy:bool:
    - children:stmts:每个子消息报文要执行的编排过程
  - exchangeProperty
    - CamelSplitIndex:int:当前子消息索引
    - CamelSplitSize:int:拆分总数
    - CamelSplitComplete:bool:最后一个子消息
- camel组件:
  - CamelComponents/EIP/Split
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"split",
  "scriptMethod":"",
  "outputMethod":"",
  "parallelProcessing":true,
  "timeout":"12",
  "copy":"true",
  "children":[
    
  ],
  "exchangeProperty":{
    "CamelSplitIndex":1,
    "CamelSplitSize":2,
    "CamelSplitComplete":true
  }
}
```
 
# 合并
- 分类:消息处理
- 输出:匹配的表达式为输出结果。无匹配则无输出
- 处理逻辑
  - 合并后的out由appender控制
  - 合并完成点由appender控制
  - aggregate
    - appender:js:追加合并脚本
    - correlationExpression:js:合并分组表达式,结果相同的消息会触发一个合并迭代
    - completionPredicate:js:合并结束断言
    - completionTimeout:int:总超时时间毫秒
  - exchangeProperty
    - AGGREGATION_COMPLETE_CURRENT_GROUP:bool:合并完成标记
    - CamelAggregatedSize:int:合并消息总数
    - CamelAggregatedCompletedBy:string:完成原因
    - CamelAggregatedCorrelationKey:string:关联key
- camel组件:
  - CamelComponents/EIP/Aggregate
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"aggregate",
  "appender":true,
  "correlationExpression":"${header.id==2}",
  "completionPredicate":"header.id==2",
  "completionTimeout":20,
  "exchangeProperty":{
    "AGGREGATION_COMPLETE_CURRENT_GROUP":"headersaa",
    "CamelAggregatedSize":2,
    "CamelAggregatedCompletedBy":"headerf",
    "CamelAggregatedCorrelationKey":"headerkey",
  }
  "children":[
    
  ]
}
```

# 请求
- 分类:协议处理
- 输出:来自ref的topic
- 处理逻辑
  - API入口
  - in消息
  - 绑定至API请求定义
  - 不可删除
  - request
    - ref:string:API_ID
- camel组件:
  - CamelComponents/Components/Kafka
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"from_kafka",
  "ref":"api_id_123",
  "children":[

  ]
}
```

# 应答
- 分类:协议处理
- 输出:来自ref的topic
- 处理逻辑
  - API出口
  - out消息
  - 绑定至API应答定义
  - 可以多个,先执行到的生效
- camel组件:
  - CamelComponents/Components/Kafka
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"to_kafka",
}
```

# 事件
- 分类:协议处理
- 输出:InOnly无输出，这仅适用于消费者使用的端点
- 处理逻辑
    - API入口
  - in消息
  - 绑定至API请求定义
  - 不可删除
  - request
    - ref:string:Event_ID
- camel组件:
  - CamelComponents/EIP/EventMessage
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"eventMessage",
  "exchangePattern":"InOnly",
  "children":[
    
  ]
}
```

# 协议校验器
- 分类:特殊
- 输出:匹配的表达式为输出结果。无匹配则无输出
- 处理逻辑
   - 根据定义校验消息报文
  - 失败时抛出异常
  - validate
    - ref:string:API_ID/Event_ID
    - direct:string:in/out
- camel组件:
  - 自己实现
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"validate",
  "ref":"API_ID",
  "direct":"in",
  "children":[
    
  ]
}
```

# 消息校验器
- 分类:特殊
- 输出:匹配的表达式为输出结果。无匹配则无输出
- 处理逻辑
  - 校验message是否合法
  - 失败时抛出异常
  - predicate必须返回bool.当返回false时校验失败,节点抛出异常
  - validate
    - predicate:js:计算报文校验是否通过
- camel组件:
  - CamelComponents/EIP/Validate
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"validate",
  "predicate":"{header.id==2}",
  "children":[
    
  ]
}
```

# 认证
- 分类:特殊
- 输出:匹配的表达式为输出结果。无匹配则无输出
- 处理逻辑
  - 使用集成平台进行认证+鉴权
  - 根据配置可能无校验
  - 根据appKey,appSec,abac进行校验
  - 缓存结果,优化读性能
  - 修改key/api/权限时缓存标脏或缓存过期
  - auth
    - 无参数
- camel组件:
  - 自己实现
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"auth"
}
```

# 限流
- 分类:特殊
- 输出:匹配的表达式为输出结果。无匹配则无输出
- 处理逻辑
  - 入口流量控制
  - 在固定周期内统计最大请求频率
  - throttle
    - expression:js:最大请求频率
    - timePeriod:int:计数周期毫秒
    - reject:bool:当触发流控时引发异常还是等待
- camel组件:
  - CamelComponents/EIP/Throttle
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"throttle",
  "expression":"${header.throttleValue}",
  "timePeriod":1000,
  "reject":true,
  "children":[
    
  ]
}
```

# 异常处理器
- 分类:特殊
- 输出:匹配的表达式为输出结果。无匹配则无输出
- 处理逻辑
  - 捕获异常会附加到message property里
  - 当编排节点抛出异常时捕获
  - onException
    - exception:[string]:捕获异常列表
    - maximumRedeliveries:int:重试次数
    - delay:int:延迟重试毫秒
    - handle:js:已解决
    - children:stmts:异常处理体
  - exchangeProperty
    - cache:object:异常对象
- camel组件:
  - Usermanual/Resources&Guides/Errorhandler
  - Usermanual/Architecture/ExceptionClause
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"onException",
  "children":[
    
  ],
  "exchangeProperty":{
    "cache":{

    }
  }
}
```

#  pre拦截器
- 分类:特殊
- 输出:最后一个child为输出
- 处理逻辑
  - 当每个编排节点执行前会调用拦截器,执行拦截处理体
  - 条件可选,默认全部匹配
  - 传入值为当前节点消息报文
  - intercept
    - predicate:js:匹配条件
    - children:stmts:拦截处理体
- camel组件:
  - CamelComponents/EIP/Intercept
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"intercept",
  "interceptFrom":{
    "uri":"jms*",
    "children":[
    
    ]
  },
  "children":[
    
  ]
}
```

# post拦截器
- 分类:特殊
- 输出:最后一个child为输出
- 处理逻辑
  - 编排执行完成后触发事后拦截器
  - 可以控制成功时或失败时触发
  - onCompletion
    - success:bool:当成功时拦截
    - failed:bool:当失败时拦截
    - children:stmts:拦截处理体
- camel组件:
  - Usermanual/Architecture/OnCompletion
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"onCompletion",
  "success":true,
  "failed":true,
  "children":[
    
  ]
}
```

# 日志
- 分类:特殊
- 输出:匹配的表达式为输出结果。无匹配则无输出
- 处理逻辑
  - 输出日志到集成平台控制台
  - 写入elk
  - 隐含携带应用id,接口id,消息id
  - log
    - level:string:trace/debug/info/warn/error/fatal
    - tag:string:日志标签
    - expresion:js:日志内容表达式
- camel组件:
  - CamelComponents/EIP/Log
- 静态配置据结构
```json

```
- 运行时数据结构
```json
{
  "node":"log",
  "message_expr":"输出日志脚本id",
  "logging_level":"ERROR", 
  "tag":"com.mycompany.MyCoolRoute"
}
```
