package com.copote.integration;

import com.alibaba.fastjson.JSONObject;
import com.copote.integration.camel.component.NodeJsProcessor;
import com.copote.integration.nodejs.NodeEngine;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.test.junit5.CamelTestSupport;
import org.junit.jupiter.api.Test;

public class TestMessageBodyProcessor extends CamelTestSupport {

    NodeEngine engine;

    TestLogger logger;

    TestMessageBodyProcessor() {
        engine = new NodeEngine(4, 2, 4);
        logger = new TestLogger();
    }

    @Override
    protected RoutesBuilder createRouteBuilder() {
        return new RouteBuilder() {
            @Override
            public void configure() {
                String convert = "(exchange)=>{ " +
                        "   let body = exchange.getMessage().getBody(); " +
                        "   if ('yuan' === body.getString('unit')) " +
                        "       body.put('res',body.amount * 100); " +
                        "   else if ('cent' === body.getString('unit')) " +
                        "       body.put('res',body.amount); " +
                        "   else " +
                        "       body.put('res', 0);" +
                        "   body.remove('amount'); " +
                        "   body.remove('unit'); " +
                        "   return;"+
                        "}";

                fromF("direct:test")
                        .process(new NodeJsProcessor(engine, "conv", 1, convert))
                        .log(LoggingLevel.INFO, logger, "${body}")
                        .to("mock:result");
            }
        };
    }

    @Test
    void Test() throws Exception {
        JSONObject body1 = JSONObject.parseObject("{'opt':'pay', 'unit':'yuan', 'amount': 123}");
        JSONObject body2 = JSONObject.parseObject("{'opt':'pay', 'unit':'cent', 'amount': 456}");

        getMockEndpoint("mock:result").expectedBodiesReceived("{\"res\":12300,\"opt\":\"pay\"}");
        template.sendBody("direct:test", body1);
        assertMockEndpointsSatisfied();

        getMockEndpoint("mock:result").reset();

        getMockEndpoint("mock:result").expectedBodiesReceived("{\"res\":456,\"opt\":\"pay\"}");
        template.sendBody("direct:test", body2);
        assertMockEndpointsSatisfied();

        System.out.println(logger);
        assert logger.toString().equals(
                "{\"res\":12300,\"opt\":\"pay\"}" + System.lineSeparator() +
                "{\"res\":456,\"opt\":\"pay\"}" + System.lineSeparator()
        );
    }
}
