package com.copote.integration;

import com.alibaba.fastjson.JSONObject;
import com.copote.integration.camel.component.NodeJsPredicate;
import com.copote.integration.nodejs.NodeEngine;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.test.junit5.CamelTestSupport;
import org.junit.jupiter.api.Test;

public class TestMessageBodyPredicate extends CamelTestSupport {

    NodeEngine engine;

    TestLogger logger;

    TestMessageBodyPredicate() {
        engine = new NodeEngine(4, 2, 4);
        logger = new TestLogger();
    }

    @Override
    protected RoutesBuilder createRouteBuilder() {
        return new RouteBuilder() {
            @Override
            public void configure() {
                String p = "(exchange)=>{ " +
                        "   return 'yuan' === exchange.getMessage().getBody().getString('unit');" +
                        "}";

                fromF("direct:test").
                        choice()
                            .when(new NodeJsPredicate(engine, "p", 1, p))
                                .log(LoggingLevel.INFO, logger, "yuan")
                            .otherwise()
                                .log(LoggingLevel.INFO, logger, "cent")
                        .endChoice()
                        .end()
                        .log(LoggingLevel.INFO, logger, "end")
                        .to("mock:result");
            }
        };
    }

    @Test
    void Test() throws Exception {
        JSONObject body1 = JSONObject.parseObject("{'opt':'pay', 'unit':'yuan', 'amount': 123}");
        JSONObject body2 = JSONObject.parseObject("{'opt':'pay', 'unit':'cent', 'amount': 456}");

        getMockEndpoint("mock:result").expectedBodiesReceived(body1.toString());
        template.sendBody("direct:test", body1);
        assertMockEndpointsSatisfied();

        getMockEndpoint("mock:result").reset();

        getMockEndpoint("mock:result").expectedBodiesReceived(body2.toString());
        template.sendBody("direct:test", body2);
        assertMockEndpointsSatisfied();

        System.out.println(logger);
        assert logger.toString().equals(
                        "yuan" + System.lineSeparator() +
                        "end" + System.lineSeparator() +
                        "cent" + System.lineSeparator() +
                        "end" + System.lineSeparator()
        );
    }
}
