package com.copote.integration;

import com.copote.integration.camel.component.NodeJsExpression;
import com.copote.integration.camel.component.NodeJsLogProcessor;
import com.copote.integration.nodejs.NodeEngine;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.test.junit5.CamelTestSupport;
import org.junit.jupiter.api.Test;

public class TestLogProcessor extends CamelTestSupport {

    NodeEngine engine;

    TestLogger logger;

    TestLogProcessor() {
        engine = new NodeEngine(4, 2, 4);
        logger = new TestLogger();
    }

    @Override
    protected RoutesBuilder createRouteBuilder() {
        String code = "(exchange)=>{" +
                "   return 'echo ' + exchange.getMessage().getBody();" +
                "}";
        return new RouteBuilder() {
            @Override
            public void configure() {
                fromF("direct:test")
                        .process(new NodeJsLogProcessor(engine, LoggingLevel.INFO, logger,
                                "logFunc", 1, code))
                        .to("mock:result");
            }
        };
    }

    @Test
    void Test() throws Exception {
        getMockEndpoint("mock:result").expectedBodiesReceived("{'msg':'hello world'}");

        template.sendBody("direct:test", "{'msg':'hello world'}");
        System.out.println(logger);
        assert logger.toString().equals("echo {'msg':'hello world'}" + System.lineSeparator());

        assertMockEndpointsSatisfied();
    }
}
