package com.copote.integration;

import com.copote.integration.camel.component.NodeJsExpression;
import com.copote.integration.nodejs.NodeEngine;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.test.junit5.CamelTestSupport;
import org.junit.jupiter.api.Test;

public class TestConstExpression extends CamelTestSupport {

    NodeEngine engine;

    TestLogger logger;

    TestConstExpression() {
        engine = new NodeEngine(4, 2, 4);
        logger = new TestLogger();
    }

    @Override
    protected RoutesBuilder createRouteBuilder() {
        return new RouteBuilder() {
            @Override
            public void configure() {
                fromF("direct:test").
                        loop(new NodeJsExpression(engine,
                                "f1",
                                1,
                                "(msg)=>{ return 3; }"))
                        .log(LoggingLevel.INFO, logger, "loop body1")
                        .log(LoggingLevel.INFO, logger, "loop body2")
                        .end()
                        .log(LoggingLevel.INFO, logger, "last message")
                        .to("mock:result");
            }
        };
    }

    @Test
    void Test() throws Exception {
        getMockEndpoint("mock:result").expectedBodiesReceived("{'msg':'hello world'}");

        template.sendBody("direct:test", "{'msg':'hello world'}");
        System.out.println(logger);
        assert logger.toString().equals(
                        "loop body1" + System.lineSeparator() +
                        "loop body2" + System.lineSeparator() +
                        "loop body1" + System.lineSeparator() +
                        "loop body2" + System.lineSeparator() +
                        "loop body1" + System.lineSeparator() +
                        "loop body2" + System.lineSeparator() +
                        "last message" + System.lineSeparator()
        );

        assertMockEndpointsSatisfied();
    }
}
