package com.copote.integration.runtime;

import lombok.extern.slf4j.Slf4j;
import org.apache.camel.builder.RouteBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Slf4j
@Component
@Scope("singleton")
public class HttpKafkaInbound extends BaseCamelRuntime {

    @Value("${integration.http2kafka.config}")
    private String _kafkaConfig;

    @Value("${integration.route.http2kafka.inbound}")
    private String _routeID;

    @Value("${integration.http2kafka.topic.inbound_request}")
    private String _topic;

    @Value("${integration.header_name.API_ID}")
    private String _headerApiId;

    @Override
    public void Startup() throws Exception {
        RouteBuilder builder = new RouteBuilder() {
            @Override
            public void configure() throws Exception {
                fromF("kafka:%s?%s", _topic, _kafkaConfig)
                        .toD(String.format("direct:API_${header.%s}", _headerApiId))
                        .routeId(_routeID);
            }
        };
        _camelContext.addRoutes(builder);
        log.info("The route [" + _routeID + "] has been added");
    }

    @Override
    public void Stop() throws Exception {
        _camelContext.removeRoute(_routeID);
        log.info("The route [" + _routeID + "] has been removed");
    }
}
