package com.copote.integration.runtime;

import org.apache.camel.CamelContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public abstract class BaseCamelRuntime implements IRuntimeLifeCycle,
        DisposableBean,
        ApplicationRunner {

    @Value("${integration.test.runtime.enable}")
    private boolean RUNTIME_ENABLE;

    protected CamelContext _camelContext;

    @Autowired
    public final void set_camelContext(CamelContext value) {
        this._camelContext = value;
    }

    @Override
    public void destroy() throws Exception {
        if (!RUNTIME_ENABLE)
            return;
        Stop();
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        if (!RUNTIME_ENABLE)
            return;
        Startup();
    }
}
