package com.copote.integration.orchestration;

import java.util.EmptyStackException;
import java.util.Stack;

public class ValidateResult {
    public enum ValidateResultCode {
        SUCCESS,
        ERROR,
    }

    private ValidateResultCode _code;

    private Exception _reason;

    private Stack<String> _path;

    public ValidateResult() {
        _code = ValidateResultCode.SUCCESS;
        _reason = null;
        _path = new Stack<>();
    }

    // deep clone constructor
    public ValidateResult(ValidateResult rhs) {
        _code = rhs._code;
        _reason = rhs._reason;
        _path = rhs._path;

        rhs._path = new Stack<>();
        rhs.reset();
    }

    public void reset() {
        _code = ValidateResultCode.SUCCESS;
        _reason = null;
        _path.clear();
    }

    public ValidateResultCode getCode() {
        return _code;
    }

    public Stack<String> getPath() {
        return _path;
    }

    public void pushPath(String name) {
        _path.push(name);
    }

    public void pushPath(int index) {
        _path.push("index_" + index);
    }

    public String popPath() {
        try {
            return _path.pop();
        } catch (EmptyStackException e) {
            return null;
        }
    }

    public ValidateResult error(Exception ex) {
        _code = ValidateResultCode.ERROR;
        _reason = ex;
        return this;
    }

    public ValidateResult end() {
        return new ValidateResult(this);
    }

    public boolean OK() {
        return _code == ValidateResultCode.SUCCESS;
    }

    public void printStack() {
        if (_reason != null)
            _reason.printStackTrace();
        for (String p : _path) {
            System.out.printf("\t%s%n", p);
        }
    }

    @Override
    public String toString() {
        return String.format("Validate:%s%nReason:%s%nPath:%s%n",
                _code.name(),
                _reason == null ? "None" : _reason.toString(),
                _path);
    }

}
