package com.copote.integration.orchestration;

import com.alibaba.fastjson.JSONObject;
import com.copote.integration.camel.component.MergeQueryHeaderProcessor;
import lombok.extern.slf4j.Slf4j;
import org.apache.camel.Exchange;
import org.apache.camel.model.ProcessorDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.util.Set;

import static org.apache.camel.builder.Builder.constant;

@Slf4j
@Scope("singleton")
@Component("toHttpNodeParser")
public class ToHttpNodeParser extends BaseSubParser {

    private static final String NAME_TYPE = "type";

    private static final String NAME_TARGET = "target";

    private static final String NAME_METHOD = "method";

    private static final String NAME_URL = "url";

    private static final Set<String> TYPE = Set.of("api", "endpoint");

    private static final Set<String> METHOD = Set.of("get", "post", "put", "delete", "head", "connect", "OPTIONS", "trace", "patch");

    private MergeQueryHeaderProcessor _mergeQueryHeaderProcessor;

    @Autowired
    public final void setMergeQueryHeaderProcessor(MergeQueryHeaderProcessor processor) {
        this._mergeQueryHeaderProcessor = processor;
    }

    @Override
    protected String nodeName() {
        return "to_http";
    }

    @Override
    public ProcessorDefinition<?> parse(JSONObject json, ProcessorDefinition<?> def) throws RuntimeException {
        boolean isAPI = json.getString(NAME_TYPE).equals("api");
        if (isAPI) {
            // call direct route
            String target = json.getString(NAME_TARGET);
            def = def.to(String.format("direct:API_%s", target));
            if (PARSER_PRINTOUT)
                log.debug(".to(\"direct:API_{}\")", target);
        } else {
            // set http query
            def = def.process(_mergeQueryHeaderProcessor);
            if (PARSER_PRINTOUT)
                log.debug(".process(_mergeQueryHeaderProcessor)");

            // set http method
            String method = json.getString(NAME_METHOD).toUpperCase();
            def.setHeader(Exchange.HTTP_METHOD, constant(method));
            if (PARSER_PRINTOUT)
                log.debug(".setHeader(Exchange.HTTP_METHOD, constant(\"{}\"))", method);

            // call http endpoint
            String url = json.getString(NAME_URL);
            String uri = String.format("ahc:%s", url);
            def = def.to(uri);
            if (PARSER_PRINTOUT)
                log.debug(".to(\"{}\")", uri);
        }

        return def;
    }

    @Override
    protected void validate(JSONObject json) throws Exception {
        ValidateNodeName(json);
        validateStringProperty(json, NAME_TYPE, TYPE, E_FieldType.Required);
        validateStringProperty(json, NAME_TARGET, E_EmptyType.NotEmpty, E_FieldType.Required);
        validateStringProperty(json, NAME_METHOD, METHOD, E_FieldType.Required);
        validateStringProperty(json, NAME_URL, E_EmptyType.NotEmpty, E_FieldType.Required);
    }
}
