package com.copote.integration.orchestration;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Slf4j
@Scope("singleton")
@Component("responseNodeParser")
public class ResponseNodeParser extends BaseSubParser {

    private static final String NAME_REF = "ref";

    @Value("${integration.http2kafka.config}")
    private String kafka_config;

    @Value("${integration.header_name.PROXY_ID}")
    private String header_proxy_id;

    @Override
    protected String nodeName() {
        return "to_kafka";
    }

    @Override
    public ProcessorDefinition<?> parse(JSONObject json, ProcessorDefinition<?> def) throws RuntimeException {
        String target = String.format("kafka:${header.%s}?%s", header_proxy_id, kafka_config);
        def = def.toD(target);
        if (PARSER_PRINTOUT)
            log.debug(".toD(\"kafka:${header.{}}?{}\")", header_proxy_id, kafka_config);
        return def;
    }

    @Override
    protected void validate(JSONObject json) throws Exception {
        ValidateNodeName(json);
        validateStringProperty(json, NAME_REF, E_EmptyType.NotEmpty, E_FieldType.Required);
    }
}
