package com.copote.integration.orchestration;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Slf4j
@Scope("singleton")
@Component("requestNodeParser")
public class RequestNodeParser extends BaseRootParser {

    private static final String NAME_REF = "ref";

    @Override
    protected String nodeName() {
        return "from_kafka";
    }

    @Override
    public void parse(JSONObject json) throws Exception {

        // create new route
        String ref = json.getString(NAME_REF);
        String routeId = "API_" + ref;
        RouteBuilder builder = new RouteBuilder() {
            @Override
            public void configure() throws Exception {
                ProcessorDefinition<?> def;
                // from
                def = from("direct:" + routeId);
                if (PARSER_PRINTOUT)
                    log.debug("from(\"direct:{}\")", routeId);

                // children
                def = parseChildren(json.getJSONArray(NAME_CHILDREN), def);

                // routeId
                def.routeId(ref);
                if (PARSER_PRINTOUT)
                    log.debug(".routeId(\"{}\")", ref);
            }
        };

        // try to remove old route
        try {
            _camelContext.getRouteController().stopRoute(routeId);
            _camelContext.removeRoute(routeId);
        } catch (Exception e) {
            log.error(e.getMessage());
        }

        // add new route
        _camelContext.addRoutes(builder);
    }

    @Override
    protected void validate(JSONObject json) throws Exception {
        ValidateNodeName(json);
        validateStringProperty(json, NAME_REF, E_EmptyType.NotEmpty, E_FieldType.Required);
        ValidateChildren(json);
    }

}
