package com.copote.integration.orchestration;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.camel.model.ProcessorDefinition;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Slf4j
@Scope("singleton")
@Component("pipelineNodeParser")
public class PipelineNodeParser extends BaseSubParser {

    @Override
    protected String nodeName() {
        return "pipeline";
    }

    @Override
    public ProcessorDefinition<?> parse(JSONObject json, ProcessorDefinition<?> def) throws RuntimeException {
        def = def.pipeline();
        if (PARSER_PRINTOUT)
            log.debug(".pipeline()");

        return def;
    }

    @Override
    protected void validate(JSONObject json) throws Exception {
        ValidateNodeName(json);
        ValidateChildren(json);
    }
}
