package com.copote.integration.orchestration;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.camel.language.simple.Simple;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.SimpleExpression;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Slf4j
@Scope("singleton")
@Component("multicastNodeParser")
public class MulticastNodeParser extends BaseSubParser {

    private static final String NAME_COPY = "copy";

    private static final String NAME_PARALLEL_PROCESSING = "parallel_processing";

    private static final String NAME_TIMEOUT = "timeout";

    private static final String NAME_STOP_ON_EXCEPTION = "stop_on_exception";

    @Override
    protected String nodeName() {
        return "multicast";
    }

    @Override
    public ProcessorDefinition<?> parse(JSONObject json, ProcessorDefinition<?> def) throws RuntimeException {

        // multicast
        MulticastDefinition multicastDefinition = def.multicast();
        if (PARSER_PRINTOUT)
            log.debug(".multicast()");

        // copy
        if (json.containsKey(NAME_COPY))
        {
            boolean copy = json.getBooleanValue(NAME_COPY);
            // TODO: onPrepare
            multicastDefinition = multicastDefinition.onPrepare((String)null);
            if (PARSER_PRINTOUT)
                log.debug(".onPrepare(xxx)");
        }

        // parallel
        if (json.containsKey(NAME_PARALLEL_PROCESSING))
        {
            boolean parallel = json.getBooleanValue(NAME_PARALLEL_PROCESSING);
            multicastDefinition = multicastDefinition.parallelProcessing(parallel);
            if (PARSER_PRINTOUT)
                log.debug(".parallelProcessing({})", parallel);
        }

        // timeout
        if (json.containsKey(NAME_TIMEOUT))
        {
            long timeout = json.getLongValue(NAME_TIMEOUT);
            multicastDefinition = multicastDefinition.timeout(timeout);
            if (PARSER_PRINTOUT)
                log.debug(".timeout({})", timeout);
        }


        // stop on exception
        if (json.getBooleanValue(NAME_STOP_ON_EXCEPTION)) {
            multicastDefinition = multicastDefinition.stopOnException();
            if (PARSER_PRINTOUT)
                log.debug(".stopOnException()");
        }

        return multicastDefinition.end();
    }

    @Override
    protected void validate(JSONObject json) throws Exception {
        ValidateNodeName(json);
        validateBoolProperty(json, NAME_COPY, E_FieldType.Optional);
        validateIntProperty(json, NAME_PARALLEL_PROCESSING, E_FieldType.Optional);
        validateIntProperty(json, NAME_TIMEOUT, E_FieldType.Optional);
        validateBoolProperty(json, NAME_STOP_ON_EXCEPTION, E_FieldType.Optional);
        ValidateChildren(json);
    }
}
