package com.copote.integration.orchestration;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.camel.LoggingLevel;
import org.apache.camel.model.ProcessorDefinition;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.util.Set;

@Slf4j
@Scope("singleton")
@Component("logNodeParser")
public class LogNodeParser extends BaseSubParser {

    private static final String NAME_MESSAGE_EXPR = "message_expr";

    private static final String NAME_LOGGING_LEVEL = "logging_level";

    private static final String NAME_TAG = "tag";

    private static final Set<String> LOG_LEVELS = Set.of("debug", "info", "warn", "error");

    @Override
    protected String nodeName() {
        return "log";
    }

    @Override
    public ProcessorDefinition<?> parse(JSONObject json, ProcessorDefinition<?> def) throws RuntimeException {
        String message = json.getString(NAME_MESSAGE_EXPR);
        String level = json.getString(NAME_LOGGING_LEVEL).toLowerCase();
        String tag = json.getString(NAME_TAG);
        LoggingLevel lLevel;
        switch (level) {
            case "debug":
                lLevel = LoggingLevel.DEBUG;
                break;
            case "info":
                lLevel = LoggingLevel.INFO;
                break;
            case "warn":
                lLevel = LoggingLevel.WARN;
                break;
            default:
                lLevel = LoggingLevel.ERROR;
                break;
        }

        // TODO: customise log component to ELK
        // TODO: get message expr result
        def = def.log(lLevel, tag, message);
        if (PARSER_PRINTOUT)
            log.debug(".log({}, \"{}\", \"{}\")", lLevel.name(), tag, message);

        return def;
    }

    @Override
    protected void validate(JSONObject json) throws Exception {
        ValidateNodeName(json);
        validateStringProperty(json, NAME_MESSAGE_EXPR, E_EmptyType.NotEmpty, E_FieldType.Required);
        validateStringProperty(json, NAME_LOGGING_LEVEL, LOG_LEVELS, E_FieldType.Required);
        validateStringProperty(json, NAME_TAG, E_EmptyType.AllowEmpty, E_FieldType.Required);
    }

}
