package com.copote.integration.orchestration;

import javax.xml.bind.ValidationException;

public class JsonValidationException extends ValidationException {

    private String _node;
    private String _property;
    private String _type;

    public String getNode() {
        return _node;
    }

    public String getProperty() {
        return _property;
    }

    public String getType() {
        return _type;
    }

    JsonValidationException(String node, String property, String type) {
        super(String.format("parser [%s] validate string [%s] failed. [%s]",
                node, property, type));
    }
}
