package com.copote.integration.nodejs;

import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

import java.lang.ref.WeakReference;

public class PooledNodeContextFactory extends BasePooledObjectFactory<NodeContext> {
    private final WeakReference<NodeEngine> _engine;

    public PooledNodeContextFactory(NodeEngine engine) {
        _engine = new WeakReference<>(engine);
    }

    @Override
    public NodeContext create() throws Exception {
        return new NodeContext(_engine);
    }

    @Override
    public PooledObject<NodeContext> wrap(NodeContext nodeContext) {
        return new DefaultPooledObject<>(nodeContext);
    }

    @Override
    public void destroyObject(PooledObject<NodeContext> p) throws Exception {
        p.getObject().close();
    }
}
