package com.copote.integration.convert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

/**
 * 文法分析器
 */
public class Parser {

    Map<Lexical.Symbol, Method> _parserMap;
    Stack<Frame> _stack;

    public Parser() throws NoSuchMethodException {
        _parserMap = new HashMap<>();
        _parserMap.put(Lexical.Symbol.Node, Parser.class.getMethod("parseNode", Lexical.class));
        _parserMap.put(Lexical.Symbol.NodeEnd, Parser.class.getMethod("parseNodeEnd", Lexical.class));
        _parserMap.put(Lexical.Symbol.Content, Parser.class.getMethod("parseContent", Lexical.class));
        _parserMap.put(Lexical.Symbol.ContentEnd, Parser.class.getMethod("parseContentEnd", Lexical.class));
        _parserMap.put(Lexical.Symbol.Children, Parser.class.getMethod("parseChildren", Lexical.class));
        _parserMap.put(Lexical.Symbol.ChildrenEnd, Parser.class.getMethod("parseChildrenEnd", Lexical.class));

        _stack = new Stack<>();
    }

    public void parse(Lexer lexer) throws ParserException {
        while (lexer.hasNext()) {
            Lexical lexical = lexer.next();
            try {
                _parserMap.get(lexical.getSymbol()).invoke(lexical);
            } catch (IllegalAccessException | InvocationTargetException ignore) {
            }
        }
    }

    public void parseNode(Lexical lexical) throws ParserException {
    }

    public void parseNodeEnd(Lexical lexical) throws ParserException {

    }

    public void parseContent(Lexical lexical) throws ParserException {

    }

    public void parseContentEnd(Lexical lexical) throws ParserException {

    }

    public void parseChildren(Lexical lexical) throws ParserException {

    }

    public void parseChildrenEnd(Lexical lexical) throws ParserException {

    }
}
