package com.copote.integration.convert;

import com.alibaba.fastjson.JSONObject;

/**
 * 词
 */
public class Lexical {

    public enum Symbol {
        Node,
        NodeEnd,
        Property,
        ChildrenCount,
        ContentCount,
        Children,
        ChildrenEnd,
        Content,
        ContentEnd,
    }

    private final Symbol _symbol;

    private Object _param0;

    private Object _param1;

    private Object _param2;

    private JSONObject _ref;

    private void reset() {
        _param0 = null;
        _param1 = null;
        _param2 = null;
        _ref = null;
    }

    private Lexical(Symbol s, Object... params) {
        _symbol = s;
        _ref = null;
        _param0 = params.length > 0 ? params[0] : null;
        _param1 = params.length > 1 ? params[1] : null;
        _param2 = params.length > 2 ? params[2] : null;
    }

    private Lexical(Symbol s, JSONObject r, Object... params) {
        _symbol = s;
        _ref = r;
        _param0 = params.length > 0 ? params[0] : null;
        _param1 = params.length > 1 ? params[1] : null;
        _param2 = params.length > 2 ? params[2] : null;
    }

    public static Lexical Node(String nodeName, int childrenCount, int contentCount) {
        return new Lexical(Symbol.Node, nodeName, childrenCount, contentCount);
    }

    public static Lexical NodeEnd() {
        return new Lexical(Symbol.NodeEnd);
    }

    public static <T> Lexical Property(String key, T value) {
        return new Lexical(Symbol.Property, key, value);
    }

    public static Lexical Children() {
        return new Lexical(Symbol.Children);
    }

    public static Lexical ChildrenEnd() {
        return new Lexical(Symbol.ChildrenEnd);
    }

    public static Lexical Content() {
        return new Lexical(Symbol.Content);
    }

    public static Lexical ContentEnd() {
        return new Lexical(Symbol.ContentEnd);
    }

    public static Lexical Node(JSONObject json, String nodeName, int childrenCount, int contentCount) {
        return new Lexical(Symbol.Node, json, nodeName, childrenCount, contentCount);
    }

    public static Lexical NodeEnd(JSONObject json) {
        return new Lexical(Symbol.NodeEnd, json);
    }

    public static <T> Lexical Property(JSONObject json, String key, T value) {
        return new Lexical(Symbol.Property, json, key, value);
    }

    public static Lexical Children(JSONObject json) {
        return new Lexical(Symbol.Children, json);
    }

    public static Lexical ChildrenEnd(JSONObject json) {
        return new Lexical(Symbol.ChildrenEnd, json);
    }

    public static Lexical Content(JSONObject json) {
        return new Lexical(Symbol.Content, json);
    }

    public static Lexical ContentEnd(JSONObject json) {
        return new Lexical(Symbol.ContentEnd, json);
    }

    public Symbol getSymbol() {
        return _symbol;
    }

    public String getNodeName() {
        if (_symbol == Symbol.Node)
            return _param0.toString();
        else
            throw new RuntimeException("this lexical is not a node");
    }

    public int getChildrenCount() {
        if (_symbol == Symbol.Node && _param1 instanceof Number)
            return ((Number)_param1).intValue();
        else
            throw new RuntimeException("this lexical is not a node");
    }

    public int getContentCount() {
        if (_symbol == Symbol.Node && _param2 instanceof Number)
            return ((Number)_param2).intValue();
        else
            throw new RuntimeException("this lexical is not a node");
    }

    public String getKey() {
        if (_symbol == Symbol.Property)
            return (String) _param0;
        else
            throw new RuntimeException("this lexical is not a property");
    }

    public String getStringValue() {
        if (_symbol == Symbol.Property && _param1 instanceof String)
            return (String) _param1;
        else
            throw new RuntimeException("this lexical is not a string property");
    }

    public double getDoubleValue() {
        if (_symbol == Symbol.Property && _param1 instanceof Number)
            return ((Number) _param1).doubleValue();
        else
            throw new RuntimeException("this lexical is not a double property");
    }

    public int getIntValue() {
        if (_symbol == Symbol.Property && _param1 instanceof Number)
            return ((Number) _param1).intValue();
        else
            throw new RuntimeException("this lexical is not a int property");
    }

    public JSONObject getRefJsonObject() {
        return _ref;
    }

    /**
     * debug calls only
     * @return: serialize lexical
     */
    @Override
    public String toString() {
        if (_param0 == null)
            return String.format("[%s]", _symbol.name());
        else if (_param1 == null)
            return String.format("[%s,%s]", _symbol.name(), _param0);
        else if (_param2 == null)
            return String.format("[%s,%s,%s]", _symbol.name(), _param0, _param1);
        else
            return String.format("[%s,%s,%s,%s]", _symbol.name(), _param0, _param1, _param2);
    }
}
