package com.copote.integration.convert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.Iterator;
import java.util.LinkedList;

/**
 * 词法分析器
 */
public class Lexer {

    private final JSONObject _json;

    private final LinkedList<Lexical> _lexicalList;

    private Iterator<Lexical> _iterator;

    public Lexer(JSONObject json) throws LexerException {
        _json = json;
        _lexicalList = new LinkedList<>();
        reset();
    }

    public Lexical next() {
        return _iterator.next();
    }

    public boolean hasNext() {
        return _iterator.hasNext();
    }

    public void reset() throws LexerException {
        tryCreateList();
        _iterator = _lexicalList.iterator();
    }

    private void tryCreateList() throws LexerException {
        if (_lexicalList.isEmpty()) {
            lex(_json);
        }
    }

    private void lex(JSONObject json) throws LexerException {
        try {
            // node
            String nodeName = json.getString("itemType");

            // sub node count
            JSONArray contentArray = json.getJSONArray("content");
            JSONArray childrenArray = json.getJSONArray("children");
            int childrenCount = childrenArray == null ? 0 : childrenArray.size();
            int contentContent = contentArray == null ? 0 : contentArray.size();

            // create node
            _lexicalList.addLast(Lexical.Node(json, nodeName, childrenCount, contentContent));

            // set property
//            for (String key : json.keySet()) {
//                if ("children".equals(key) || "content".equals(key))
//                    continue;
//                _lexicalList.addLast(Lexical.Property(key, json.get(key)));
//            }

            // node content
            if (contentArray != null) {
                _lexicalList.addLast(Lexical.Content(json));
                for (int i = 0; i < contentArray.size(); ++i) {
                    lex(contentArray.getJSONObject(i));
                }
                _lexicalList.addLast(Lexical.ContentEnd(json));
            }

            // node children
            if (childrenArray != null) {
                _lexicalList.addLast(Lexical.Children(json));
                for (int i = 0; i < childrenArray.size(); ++i) {
                    lex(childrenArray.getJSONObject(i));
                }
                _lexicalList.addLast(Lexical.ChildrenEnd(json));
            }

            // node end
            _lexicalList.addLast(Lexical.NodeEnd(json));

        }catch (Exception e) {
            throw new LexerException(e.getMessage(), e, json);
        }
    }
}
