package com.copote.integration.camel.component;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.util.HashMap;

@Scope("singleton")
@Component("splitQueryHeaderProcessor")
public class SplitQueryHeaderProcessor implements Processor {
    @Value("${integration.header_name.HTTP_QUERY_MAP}")
    private String HTTP_QUERY_MAP;

    @Override
    public void process(Exchange exchange) throws Exception {
        Message msg = exchange.getMessage();

        // no query parameters
        String queryStr = exchange.getMessage().getHeader(Exchange.HTTP_QUERY, String.class);
        if (queryStr == null || queryStr.isEmpty()) {
            msg.setHeader(HTTP_QUERY_MAP, new HashMap<String, String>());
            return;
        }

        // make query map
        HashMap<String, String> query = new HashMap<>();
        for (final String kv : queryStr.split("&")) {
            String[] pair = kv.split("=");
            if (pair.length >= 2) {
                query.put(pair[0], pair[1]);
            } else {
                query.put(pair[0], "");
            }
        }

        exchange.getMessage().setHeader(HTTP_QUERY_MAP, query);
    }
}
