package com.copote.integration.camel.component;

import com.copote.integration.nodejs.NodeEngine;
import lombok.extern.slf4j.Slf4j;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;

@Slf4j
public class NodeJsProcessor implements Processor {

    private final NodeEngine _engine;

    private final String _id;

    private final long _version;

    private final String _code;

    public NodeJsProcessor(NodeEngine engine, String id, long version, String code) {
        _engine = engine;
        _id = id;
        _version = version;
        _code = code;

        init();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        _engine.call(_id, void.class, exchange);
    }

    private void init() {
        try {
            _engine.put(_id, _version, _code);
        } catch (Exception ex) {
            log.error("init nodejs processor exception", ex);
        }
    }
}
