package com.copote.integration.camel.component;

import com.copote.integration.nodejs.NodeEngine;
import lombok.extern.slf4j.Slf4j;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;

@Slf4j
public class NodeJsPredicate implements Predicate {

    private final NodeEngine _engine;

    private final String _id;

    private final long _version;

    private final String _code;

    public NodeJsPredicate(NodeEngine engine, String id, long version, String code) {
        _engine = engine;
        _id = id;
        _version = version;
        _code = code;
    }

    @Override
    public boolean matches(Exchange exchange) {
        try {
            return _engine.call(_id, boolean.class, exchange);
        } catch (Exception ex) {
            log.error("evaluate nodejs predicate exception", ex);
            return false;
        }
    }

    @Override
    public void init(CamelContext context) {
        Predicate.super.init(context);

        try {
            _engine.put(_id, _version, _code);
        } catch (Exception ex) {
            log.error("init nodejs predicate exception", ex);
        }
    }
}
