package com.copote.integration.camel.component;

import com.copote.integration.nodejs.NodeEngine;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.slf4j.Logger;

public class NodeJsLogProcessor implements Processor {

    private final NodeEngine _engine;

    private final LoggingLevel _level;

    private final Logger _logger;

    private final String _id;

    private final long _version;

    private final String _code;

    private final String _message;

    private final Exception _code_exception;

    public NodeJsLogProcessor(LoggingLevel level, Logger logger, String message) {
        _level = level;
        _logger = logger;
        _message = message;

        _engine = null;
        _id = null;
        _version = 0;
        _code = null;
        _code_exception = null;
    }

    public NodeJsLogProcessor(NodeEngine engine,
                              LoggingLevel level, Logger logger,
                              String id, long version, String code) {
        _engine = engine;
        _level = level;
        _logger = logger;
        _id = id;
        _version = version;
        _code = code;
        _message = null;

        Exception catchException = null;
        try {
            initNodeJsCode();
        } catch (Exception ex) {
            catchException = ex;
        } finally {
            _code_exception = catchException;
        }
    }

    private void initNodeJsCode() throws Exception {
        if (_engine != null)
            _engine.put(_id, _version, _code);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        // init exception
        if (_code_exception != null)
            throw _code_exception;

        // init success
        if (_engine != null) {
            String result = _engine.call(_id, String.class, exchange);
            doLog(result);
        } else {
            doLog(_message);
        }
    }

    private void doLog(String msg) {
        switch (_level){
            case DEBUG:
                _logger.debug(msg);
                break;
            case ERROR:
                _logger.error(msg);
                break;
            case INFO:
                _logger.info(msg);
                break;
            case WARN:
                _logger.warn(msg);
                break;
            case TRACE:
                _logger.trace(msg);
                break;
            default:
                // do nothing
        }
    }
}
