package com.copote.integration.camel.component;

import com.copote.integration.nodejs.NodeEngine;
import lombok.extern.slf4j.Slf4j;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;

@Slf4j
public class NodeJsExpression implements Expression {

    private final NodeEngine _engine;

    private final String _id;

    private final long _version;

    private final String _code;

    public NodeJsExpression(NodeEngine engine, String id, long version, String code) {
        _engine = engine;
        _id = id;
        _version = version;
        _code = code;
    }

    @Override
    public <T> T evaluate(Exchange exchange, Class<T> type) {
        try {
            return _engine.call(_id, type, exchange);
        } catch (Exception ex) {
            log.error("evaluate nodejs expression exception", ex);
            return null;
        }
    }

    @Override
    public void init(CamelContext context) {
        Expression.super.init(context);
        try {
            _engine.put(_id, _version, _code);
        } catch (Exception ex) {
            log.error("init nodejs expression exception", ex);
        }
    }
}
