package com.copote.integration.camel.component;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;

@SuppressWarnings("unchecked")
@Scope("singleton")
@Component("mergeQueryHeaderProcessor")
public class MergeQueryHeaderProcessor implements Processor {

    private static class KVIterator implements Iterator<String> {

        private final Iterator<Map.Entry<String, String>> _iterator;

        public KVIterator(Iterator<Map.Entry<String, String>> iterator) {
            _iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return _iterator.hasNext();
        }

        @Override
        public String next() {
            Map.Entry<String, String> entry = _iterator.next();
            return entry.getKey() + "=" + entry.getValue();
        }
    }

    private static class KVIterable implements Iterable<String> {
        private final WeakReference<Set<Map.Entry<String,String>>> _kvSet;

        public KVIterable(Set<Map.Entry<String, String>> kvSet) {
            _kvSet = new WeakReference<>(kvSet);
        }

        @Override
        public Iterator<String> iterator() {
            Set<Map.Entry<String, String>> set = _kvSet.get();
            if (set == null)
                return null;
            return new KVIterator(set.iterator());
        }

        @Override
        public void forEach(Consumer<? super String> action) {
            Iterable.super.forEach(action);
        }

        @Override
        public Spliterator<String> spliterator() {
            return Iterable.super.spliterator();
        }
    }

    @Value("${integration.header_name.HTTP_QUERY_MAP}")
    private String HTTP_QUERY_MAP;

    @Override
    public void process(Exchange exchange) throws Exception {
        Message msg = exchange.getMessage();
        // no query parameters
        Map<String, String> queryMap = exchange.getMessage().getHeader(HTTP_QUERY_MAP, Map.class);
        if (queryMap == null || queryMap.size() == 0) {
            msg.setHeader(Exchange.HTTP_QUERY, "");
            return;
        }

        String result = String.join("&", new KVIterable(queryMap.entrySet()));
        msg.setHeader(Exchange.HTTP_QUERY, result);
        System.out.println(msg);
    }
}
