package com.copote.integration.api;

import com.alibaba.fastjson.JSONObject;
import com.copote.integration.orchestration.BaseParser;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

@Slf4j
@Component
@Controller
@RequestMapping("/test")
public class TestAPI {

    @RequestMapping(value = "/echoGet", method = RequestMethod.GET)
    public @ResponseBody String echo(@RequestParam("value") String input) {
        log.info(input);
        return input;
    }

    @RequestMapping(value = "/echoPost", method = RequestMethod.POST)
    public @ResponseBody String echoPost(@RequestBody JSONObject input) {
        log.info(input.toString());
        return input.toString();
    }

    @RequestMapping(value = "/validate", method = RequestMethod.POST)
    public @ResponseBody String validate(@RequestBody JSONObject orchestrationJson) {
        return BaseParser.Validate(orchestrationJson).toString();
    }

    @RequestMapping(value = "/parse", method = RequestMethod.POST)
    public @ResponseBody String parser(@RequestBody JSONObject orchestrationJson) {

        return BaseParser.Parse(orchestrationJson).toString();
    }
}
