import bpy

from mathutils import Vector, Matrix
from bpy.utils import register_class, unregister_class
from bpy.types import PropertyGroup, Object, Collection
from bpy.props import *

from . import data, last, object, scene, snap, preference
from . utility import update
from ... utility import addon


auto_smooth_override = False


class new:
    datablock = {
        'targets': [],
        'wire_targets': [],
        'overrides': [],
        'dimensions': Vector((0, 0, 0)),
        'slices': [],
        'operator': None,
        'duplicate': None,
        'plane': None,
        'box': None,
        'modifier': {
            'bevel': []}}

    ray_cast = {
        'location': Vector((0, 0, 0)),
        'normal': Vector((0, 0, 0))}

    start = {
        'accucut': False,
        'alignment': '',
        'mouse': Vector(),
        'matrix': Matrix(),
        'mode': 'CUT',
        'operation': 'NONE',
        'location': Vector(),
        'extrude': 0.0,
        'offset': 0.0,
        'displace': 0.0}

    geo = {
        'points': [],
        'verts': [],
        'edges': [],
        'faces': [],
        'indices': {
            'offset': [],
            'extrusion': [],
            'bot_edge': [],
            'top_edge': [],
            'mid_edge': []}}

    mouse = {
        'location': Vector(),
        'intersect': Vector()}

    view3d = {
        'origin': Vector(),
        'location': Vector()}

    logo_verts = [
        Vector((-0.9469696283340454, 0.9469699859619141, -0.12500010430812836)),
        Vector((-0.9469702243804932, -0.9469695091247559, -0.12500010430812836)),
        Vector((-0.8134475350379944, -0.8134468197822571, -0.12500011920928955)),
        Vector((-0.8134469985961914, 0.8134472370147705, -0.12500010430812836)),
        Vector((-0.12215916812419891, 0.2907196283340454, -0.12499996274709702)),
        Vector((-0.622159481048584, -0.6221588850021362, -0.12500007450580597)),
        Vector((-0.2017046958208084, 0.2017044872045517, -0.1250000149011612)),
        Vector((-0.2907198965549469, 0.29071974754333496, -0.1250000149011612)),
        Vector((-0.2907200753688812, -0.29071974754333496, -0.1250000149011612)),
        Vector((-0.20170487463474274, -0.20170451700687408, -0.125)),
        Vector((0.20170442759990692, 0.20170436799526215, -0.12499993294477463)),
        Vector((0.6221586465835571, -0.6221591234207153, -0.12499990314245224)),
        Vector((0.6221590042114258, 0.6221587657928467, -0.12499989569187164)),
        Vector((0.29071947932243347, 0.29071956872940063, -0.12499991804361343)),
        Vector((0.813446581363678, -0.8134471774101257, -0.12499988079071045)),
        Vector((0.8134470582008362, 0.8134467005729675, -0.12499987334012985)),
        Vector((0.9469690322875977, -0.9469701051712036, -0.12499984353780746)),
        Vector((0.9469696283340454, 0.9469693899154663, -0.12499985098838806)),
        Vector((-0.9999998211860657, 1.000000238418579, 0.12499984353780746)),
        Vector((-0.9999999403953552, 1.000000238418579, -0.12500011920928955)),
        Vector((1.0, 0.9999996423721313, 0.12500014901161194)),
        Vector((1.0000001192092896, 0.9999996423721313, -0.12499984353780746)),
        Vector((-1.0000004768371582, -0.9999998211860657, 0.12499984353780746)),
        Vector((-1.0000005960464478, -0.9999996423721313, -0.12500011920928955)),
        Vector((0.9999994039535522, -1.000000238418579, 0.12500014901161194)),
        Vector((0.999999463558197, -1.0000004768371582, -0.12499984353780746)),
        Vector((0.20170463621616364, 0.20170436799526215, 0.07091348618268967)),
        Vector((-0.20170466601848602, -0.20170451700687408, 0.07091344147920609)),
        Vector((-0.20170454680919647, 0.20170442759990692, 0.07091342657804489)),
        Vector((-0.29071956872940063, 0.2907196879386902, 0.0709134116768837)),
        Vector((0.2907196879386902, 0.2907196283340454, 0.07091350108385086)),
        Vector((-0.29071980714797974, -0.29071974754333496, 0.0709134116768837)),
        Vector((0.6221590042114258, 0.6221587657928467, 0.07091355323791504)),
        Vector((0.6221586465835571, -0.6221591234207153, 0.07091353833675385)),
        Vector((-0.6221594214439392, -0.6221588850021362, 0.07091337442398071)),
        Vector((-0.8134468793869019, 0.8134471774101257, 0.07091333717107773)),
        Vector((0.8134470582008362, 0.8134467005729675, 0.07091356068849564)),
        Vector((0.813446581363678, -0.8134472966194153, 0.07091354578733444)),
        Vector((-0.8134473562240601, -0.8134468197822571, 0.07091335207223892)),
        Vector((-0.9469695091247559, 0.9469699263572693, 0.07091334462165833)),
        Vector((-0.9469701051712036, -0.9469693899154663, 0.07091332972049713)),
        Vector((0.9469698667526245, 0.9469693303108215, 0.07091361284255981)),
        Vector((0.9469692707061768, -0.9469699859619141, 0.07091359794139862)),
        Vector((1.6888314746665856e-07, -1.0, 0.1249999850988388)),
        Vector((-3.6557452176566585e-07, 0.9999999403953552, 0.1249999850988388)),
        Vector((-4.336593519838061e-07, 0.9469696879386902, 0.07091347873210907)),
        Vector((-2.9676041890525084e-07, 0.8134469389915466, 0.07091344892978668)),
        Vector((2.743961324824795e-08, -0.6221590042114258, 0.07091346383094788)),
        Vector((-1.9263224260157585e-07, 0.2907196581363678, 0.07091345638036728)),
        Vector((-2.2057558624055673e-07, 0.20170439779758453, 0.07091345638036728)),
        Vector((-1.6468469254959928e-07, -2.2450952030794724e-07, 0.07091346383094788)),
        Vector((8.742280499518529e-08, -1.0, -0.12499997019767761)),
        Vector((-3.874302194617485e-07, 0.9999999403953552, -0.12499997019767761)),
        Vector((1.040698549559238e-07, -0.9469698071479797, -0.12499997019767761)),
        Vector((2.6995781610139602e-08, -0.8134470582008362, 0.07091344892978668)),
        Vector((7.448777239460469e-08, -0.9469696879386902, 0.07091346383094788)),
        Vector((-4.338795918101823e-07, 0.9469696879386902, -0.12499997019767761)),
        Vector((2.060333201825415e-07, -0.6221590042114258, -0.1249999850988388)),
        Vector((1.459848562035404e-07, -0.8134469985961914, -0.125)),
        Vector((-2.075736773576864e-07, 0.8134469389915466, -0.1249999850988388)),
        Vector((-8.854431854388167e-08, 0.2907196283340454, -0.12499995529651642)),
        Vector((-8.668533268973988e-08, 0.20170442759990692, -0.12499997019767761)),
        Vector((-6.059667612134945e-08, 8.841485055199882e-08, -0.12499996274709702)),
    ]

    logo_edges = [
        (6, 9), (2, 38), (7, 29), (12, 32),
        (14, 37), (2, 58), (18, 19), (13, 30),
        (27, 28), (21, 25), (35, 38), (31, 34),
        (11, 57), (7, 8), (4, 7), (22, 43),
        (19, 52), (27, 50), (25, 51), (9, 62),
        (18, 22), (15, 59), (6, 28), (33, 47),
        (3, 35), (11, 33), (2, 3), (29, 31),
        (36, 37), (8, 31), (9, 27), (42, 55),
        (37, 54), (39, 40), (16, 17), (20, 44),
        (16, 53), (30, 32), (4, 60), (19, 23),
        (41, 42), (29, 48), (11, 12), (1, 40),
        (20, 21), (26, 49), (35, 46), (24, 25),
        (5, 8), (17, 41), (16, 42), (32, 33),
        (12, 13), (20, 24), (22, 23), (0, 56),
        (14, 15), (0, 39), (0, 1), (39, 45),
        (10, 26), (15, 36), (10, 61), (5, 34),
        (44, 52), (45, 46), (46, 59), (48, 49),
        (47, 50), (51, 53), (43, 51), (52, 56),
        (53, 55), (54, 55), (45, 56), (57, 58),
        (54, 58), (47, 57), (48, 60), (59, 60),
        (49, 61), (50, 62), (61, 62), (24, 43),
        (34, 47), (21, 52), (30, 48), (17, 56),
        (18, 44), (26, 50), (6, 61), (1, 53),
        (23, 51), (5, 57), (14, 58), (10, 62),
        (40, 55), (28, 49), (13, 60), (3, 59),
        (38, 54), (36, 46), (41, 45),
    ]

    logo_faces = [
        (35, 3, 2, 38),
        (9, 6, 61, 62),
        (46, 45, 41, 42, 55, 54, 37, 36),
        (40, 1, 0, 39),
        (33, 11, 57, 47),
        (23, 22, 18, 19),
        (21, 20, 24, 25),
        (39, 0, 56, 45),
        (37, 14, 15, 36),
        (30, 13, 12, 32),
        (36, 15, 59, 46),
        (26, 10, 61, 49),
        (34, 5, 8, 31),
        (27, 9, 62, 50),
        (29, 7, 4, 60, 48),
        (31, 8, 7, 29),
        (19, 18, 44, 52),
        (32, 12, 11, 33),
        (25, 24, 43, 51),
        (42, 16, 53, 55),
        (38, 2, 58, 54),
        (41, 17, 16, 42),
        (57, 58, 2, 3, 59, 60, 4, 7, 8, 5),
        (56, 52, 21, 25, 51, 53, 16, 17),
        (28, 6, 9, 27),
        (29, 48, 49, 28, 27, 50, 47, 34, 31),
        (47, 50, 26, 49, 48, 30, 32, 33),
        (53, 51, 23, 19, 52, 56, 0, 1),
        (45, 56, 17, 41),
        (51, 43, 22, 23),
        (54, 55, 40, 39, 45, 46, 35, 38),
        (46, 59, 3, 35),
        (52, 44, 20, 21),
        (48, 60, 13, 30),
        (54, 58, 14, 37),
        (50, 62, 10, 26),
        (49, 61, 6, 28),
        (55, 53, 1, 40),
        (62, 61, 10),
        (47, 57, 5, 34),
        (15, 14, 58, 57, 11, 12, 13, 60, 59),
        (43, 24, 20, 44, 18, 22),
    ]


class option(PropertyGroup):
    # running: BoolProperty()
    addon: StringProperty(default=addon.name)


classes = [
    data.option,
    last.option,
    object.option,
    snap.option,
    scene.option,
    option]


def register():
    global auto_smooth_override

    for cls in classes:
        register_class(cls)

    bpy.types.WindowManager.bc = PointerProperty(type=option)
    bpy.types.Object.bc = PointerProperty(type=object.option)
    bpy.types.Mesh.bc = PointerProperty(type=data.option)
    bpy.types.Lattice.bc = PointerProperty(type=data.option)
    bpy.types.Scene.bc = PointerProperty(type=scene.option)
    bpy.types.Collection.hopscutter = BoolProperty()

    if addon.hops():
        import importlib
        hops = importlib.import_module(bpy.context.window_manager.Hard_Ops_folder_name)

        if hasattr(hops.src.property, 'auto_smooth_override'):
            auto_smooth_override = hops.src.property.auto_smooth_override

    if not 'use_auto_smooth' in bpy.types.Mesh.bl_rna.properties:
        from math import radians
        from . utility import update

        auto_smooth_override = True

        bpy.types.Object.auto_smooth_modifier = StringProperty()
        bpy.types.Mesh.use_auto_smooth = BoolProperty(update=update.use_auto_smooth)
        bpy.types.Mesh.auto_smooth_angle = FloatProperty(update=update.auto_smooth_angle, subtype='ANGLE', default=radians(30))


def unregister():
    global auto_smooth_override

    for cls in classes:
        unregister_class(cls)

    del bpy.types.WindowManager.bc
    del bpy.types.Object.bc
    del bpy.types.Mesh.bc
    del bpy.types.Lattice.bc
    del bpy.types.Scene.bc

    if auto_smooth_override and not addon.hops():
        del bpy.types.Object.auto_smooth_modifier
        del bpy.types.Mesh.use_auto_smooth
        del bpy.types.Mesh.auto_smooth_angle

        auto_smooth_override = False

    if not addon.hops():
        del bpy.types.Collection.hopscutter
